uniform sampler2D iChannel1;
uniform sampler2D tex0;
uniform sampler2D tex1;
uniform vec2 iResolution;
uniform float iGlobalTime;
vec2 iMouse = vec2(sin(iGlobalTime)*1000.,sin(iGlobalTime*1.3563453)*1000.);


// Interpolated values from the vertex shaders
#define inputtex iChannel1
const float HOELDER_MAKINEN_MAGIC_CONSTANT = 0.707;

mat2 rotate(float a) {
    return mat2(cos(a), sin(a), -sin(a), cos(a));
}

float intensity(vec4 color) {
    return dot(vec3(.2126, .7152, .0722), sqrt(color.rgb));
}

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec4 sampleme(vec2 uv) {
    
    vec2 unrotd = uv;
    float ar = (iResolution.y/iResolution.x);
    uv = rotate(-0.11*iGlobalTime + 42.5 * 3.141 / 180.0) * vec2(uv.x, uv.y*ar);

    float nballs = 14.0;
    vec2 center = 3.5*fract(nballs * uv ) - 1.75;
    float dist = length(center);

    float radius = intensity(texture2D(iChannel1, unrotd));
    vec4 highlight = vec4(0.0, 0.0, 0.0, 1.0);
    vec4 background = vec4(1.0, 1.0, 1.0, 1.0);
    return mix(background, highlight, step(radius, dist));
}


void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = fragCoord.xy / iResolution.xy;
  	fragColor = sampleme(uv);
  	for (int i = 0; i < 4; i++) {
      vec2 pt = float(i)*uv;
      
      fragColor += sampleme(pt);
  }
  fragColor = fragColor;
  //fragColor *= texture2D(iChannel1, uv);
}

void main() {
    vec4 fragColor = vec4( 0.);
    vec2 fragCoord = gl_FragCoord.xy;
    mainImage( fragColor, fragCoord);
    vec3 c = mix(vec3(0.3,0.2,0.3), vec3(0.8,0.7,0.4), fragColor.r);
    gl_FragColor = vec4(pow(c, vec3(1.0/2.2)), 1.0);
}